CREATE OR REPLACE PACKAGE BODY TBICDS.PCK_REGION_SITE is
/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
/*****
Description: Gets regions
******/
procedure GetRegionRS (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2,
      rs                        out refCursor
      )
is

     v_vSQL varchar2(500) :=
      'SELECT t.*
       FROM utl_region t
       order by upper(t.region_name) asc';
begin

    po_nStatusCode    := 0;
    po_vStatusComment := '';
    
    --open the result set
    open rs for v_vSQL;
    commit;

exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
      
end;

/*****
Description: Gets region sites
******/
procedure GetSiteRS (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      pi_nRegionID              in number,
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2,
      rs                        out refCursor
      )
is

     v_vSQL varchar2(500) :=
      'SELECT t.*
       FROM utl_site t
       WHERE t.region_id = :region_id
       order by upper(t.site_name) asc';
begin

    po_nStatusCode    := 0;
    po_vStatusComment := '';
    
    --open the result set
    open rs for v_vSQL using pi_nregionid;
    commit;

exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
 
end;

/*****
Description: gets the site and region matching the server 
and port passed in used when accessing the site from the CPRS tools menu
******/
procedure GetSiteRS (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      pi_vSRV                   in varchar2,
      pi_vPORT                  in varchar2,
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2,
      rs                        out refCursor
      )
is

     v_vSQL varchar2(500) :=
      'SELECT t.*, t2.region_name 
       FROM utl_site t, utl_region t2 
       WHERE lower(t.srv) = lower(:SRV)
       and lower(t.port) = lower(:PORT)
       and t.region_id = t2.region_id
       order by upper(t.site_name) asc';
begin

    po_nStatusCode    := 0;
    po_vStatusComment := '';
    
    --open the result set
    open rs for v_vSQL using pi_vSRV, pi_vPORT;
    commit;

exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
 
end;

/*gets all sites*/
procedure GetSiteRS (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2,
      rs                        out refCursor
      )
is

     v_vSQL varchar2(500) :=
      'SELECT t.*, t2.region_name 
       FROM utl_site t, utl_region t2 
       WHERE t.region_id = t2.region_id
       order by upper(t.site_name) asc';
begin

    po_nStatusCode    := 0;
    po_vStatusComment := '';
    
    --open the result set
    open rs for v_vSQL;
    commit;

exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
 
end;

END;
/

